#pragma once

#include <iostream>
#include <cmath>
#include <stdexcept>
#include <limits>

class ComplexNumber {
public:
	ComplexNumber(double real, double imaginary);
	~ComplexNumber() = default;

	double Re() const;
	double Im() const;
  void setRe(double real);
  void setIm(double imaginary);

  void conjugate();
  double magnitude() const;
	
	ComplexNumber operator+(const ComplexNumber &other);
  ComplexNumber operator-(const ComplexNumber &other);
  ComplexNumber operator*(const ComplexNumber &other);
  ComplexNumber operator/(const ComplexNumber &other);
  
  friend std::ostream &operator<<(std::ostream &os, const ComplexNumber &c);

private:
  void isNan(double real, double imaginary) const;
	
private:
	double _real;
	double _imaginary;
};