#!/bin/bash

# clean up before building
rm -rf build coverage
mkdir -p build
mkdir -p coverage


# compile source files into object files
g++ -c -g --coverage -std=c++20 -I. ./src/complexNumbers.cpp -o ./build/complexNumbers.o
g++ -c -g --coverage -std=c++20 -I. -I ~/libs/include/ ./tests/unit/testComplexNumbers.cpp -o ./build/testComplexNumbers.o

# create test executable
g++ -std=c++20 ./build/complexNumbers.o ./build/testComplexNumbers.o -o ./build/testComplexNumbers -L ~/libs/lib -lgtest -lgcov 

# run tests
./build/testComplexNumbers

# capture coverage
lcov --capture --directory ./build --output-file ./build/coverage.info

# extract coverage from the source (src) directory
lcov --extract ./build/coverage.info '*/src/*' --output-file ./build/coverage-src.info
lcov --remove ./build/coverage-src.info '*/tests/*' --output-file ./build/coverage-final.info

# generate HTML report
genhtml ./build/coverage-final.info --output-directory coverage