#include <filesystem>

#include "gtest/gtest.h"
#include "gmock/gmock.h"

#include "tests/unit/parameterReadingJsonMock.hpp"

TEST(ParameterReadingJson, ReadJsonFileMock) {
  // Arrange inputs
  ParameterReaderJsonMock parameterReadingMock;
  nlohmann::json expectedJsonFile = {
    {"iterations", 100},
    {"turbulence_model", "Spalart-Allmaras"}   
  };

  // Arrange mocks
  EXPECT_CALL(parameterReadingMock, read(std::filesystem::path("input.json"))).WillOnce(::testing::Return(expectedJsonFile));
  
  // Act
  auto inputFile = parameterReadingMock.read(std::filesystem::path("input.json"));

  // Assert
  ASSERT_EQ(inputFile, expectedJsonFile);
  ASSERT_EQ(inputFile["iterations"], 100);
  ASSERT_EQ(inputFile["turbulence_model"], "Spalart-Allmaras");
}