#pragma once

#include <filesystem>
#include <fstream>

#include "nlohmann/json.hpp"

#include "src/parameterReaderBase.hpp"

class ParameterReaderJson : public ParameterReaderBase<nlohmann::json> {
public:
  ParameterReaderBase::FileType read(std::filesystem::path file) override {
    nlohmann::json jsonFile;
    std::ifstream inputFile(file);
    inputFile >> jsonFile;
    inputFile.close();
    return jsonFile;
  }
};