#include <cmath>

#include "gtest/gtest.h"

#include "linearAlgebraLib/linearAlgebraLib.hpp"

TEST(VectorTest, Size) {
  // Arrange
  linearAlgebraLib::Vector vector(3);

  // Act
  auto vectorSize = vector.size();

  // Assert
  ASSERT_EQ(vectorSize, 3);
}

TEST(VectorTest, Access) {
  // Arrange
  linearAlgebraLib::Vector vector(3);
  vector[0] = 1.0;
  vector[1] = 1.7;
  vector[2] = -3.3;

  // Act

  // Assert
  ASSERT_DOUBLE_EQ(vector[0], 1.0);
  ASSERT_DOUBLE_EQ(vector[1], 1.7);
  ASSERT_DOUBLE_EQ(vector[2], -3.3);
}

TEST(VectorTest, L2Norm) {
  // Arrange
  linearAlgebraLib::Vector vector(3);
  vector[0] = 1.0;
  vector[1] = 1.0;
  vector[2] = 1.0;

  // Act
  auto L2Norm = vector.getL2Norm();

  // Assert
  ASSERT_DOUBLE_EQ(L2Norm, std::sqrt(3.0));
}

TEST(VectorTest, VectorAddition) {
  // Arrange
  linearAlgebraLib::Vector vector(3);
  vector[0] = 1.0;
  vector[1] = 2.3;
  vector[2] = -0.7;

  // Act
  auto result = vector + vector;

  // Assert
  ASSERT_DOUBLE_EQ(result[0], 2.0);
  ASSERT_DOUBLE_EQ(result[1], 4.6);
  ASSERT_DOUBLE_EQ(result[2], -1.4);
}

TEST(VectorTest, VectorSubtraction) {
  // Arrange
  linearAlgebraLib::Vector vector(3);
  vector[0] = 1.0;
  vector[1] = 2.3;
  vector[2] = -0.7;

  // Act
  auto result = vector - vector;

  // Assert
  ASSERT_DOUBLE_EQ(result[0], 0.0);
  ASSERT_DOUBLE_EQ(result[1], 0.0);
  ASSERT_DOUBLE_EQ(result[2], 0.0);
}

TEST(VectorTest, VectorDotProduct) {
  // Arrange
  linearAlgebraLib::Vector vector(3);
  vector[0] = 1.0;
  vector[1] = 2.0;
  vector[2] = -3.0;

  // Act
  auto result = vector.transpose() * vector;

  // Assert
  ASSERT_DOUBLE_EQ(result, 14.0);
}

TEST(VectorTest, VectorMultiplication) {
  // Arrange
  linearAlgebraLib::Vector vector(3);
  vector[0] = 1.0;
  vector[1] = 2.0;
  vector[2] = -3.0;

  // Act
  auto result = 2.0 * vector;

  // Assert
  ASSERT_DOUBLE_EQ(result[0], 2.0);
  ASSERT_DOUBLE_EQ(result[1], 4.0);
  ASSERT_DOUBLE_EQ(result[2], -6.0);
}