#include "gtest/gtest.h"

#include "linearAlgebraLib/linearAlgebraLib.hpp"

TEST(MatrixTest, RowsAndColumns) {
  // Arrange
  linearAlgebraLib::SparseMatrixCSR matrix(3, 5);

  // Act

  // Assert
  ASSERT_EQ(matrix.getNumberOfRows(), 3);
  ASSERT_EQ(matrix.getNumberOfColumns(), 5);
}

TEST(MatrixTest, SetAndGetValue) {
  // Arrange
  linearAlgebraLib::SparseMatrixCSR matrix(3, 3);
  matrix.set(2, 1, 8.0);
  matrix.set(0, 1, 2.0);
  matrix.set(1, 0, 4.0);
  matrix.set(2, 2, 9.0);
  matrix.set(1, 1, 5.0);
  matrix.set(0, 0, 1.0);
  matrix.set(2, 0, 7.0);
  matrix.set(0, 2, 3.0);
  matrix.set(1, 2, 6.0);

  // Act

  // Assert
  ASSERT_DOUBLE_EQ(matrix.get(0, 0), 1.0);
  ASSERT_DOUBLE_EQ(matrix.get(0, 1), 2.0);
  ASSERT_DOUBLE_EQ(matrix.get(0, 2), 3.0);
  ASSERT_DOUBLE_EQ(matrix.get(1, 0), 4.0);
  ASSERT_DOUBLE_EQ(matrix.get(1, 1), 5.0);
  ASSERT_DOUBLE_EQ(matrix.get(1, 2), 6.0);
  ASSERT_DOUBLE_EQ(matrix.get(2, 0), 7.0);
  ASSERT_DOUBLE_EQ(matrix.get(2, 1), 8.0);
  ASSERT_DOUBLE_EQ(matrix.get(2, 2), 9.0);
}

TEST(MatrixTest, ScalarMultiplication) {
  // Arrange
  linearAlgebraLib::SparseMatrixCSR matrix(3, 3);
  matrix.set(0, 0, 1.0);
  matrix.set(1, 1, 2.0);
  matrix.set(2, 2, -3.0);

  // Act
  auto result = 2.0 * matrix;

  // Assert
  ASSERT_DOUBLE_EQ(result.get(0, 0), 2.0);
  ASSERT_DOUBLE_EQ(result.get(1, 1), 4.0);
  ASSERT_DOUBLE_EQ(result.get(2, 2), -6.0);
}