#include "gtest/gtest.h"

#include "linearAlgebraLib/linearAlgebraLib.hpp"

TEST(ConjugateGradientTest, ConjugateGradient) {
  // Arrange
  linearAlgebraLib::SparseMatrixCSR matrix(3, 3);
  matrix.set(0, 0, 1.0);
  matrix.set(0, 1, 2.0);
  matrix.set(0, 2, 0.0);
  matrix.set(1, 0, 2.0);
  matrix.set(1, 1, 1.0);
  matrix.set(1, 2, 2.0);
  matrix.set(2, 0, 0.0);
  matrix.set(2, 1, 2.0);
  matrix.set(2, 2, 1.0);

  linearAlgebraLib::Vector rightHandSide(3);
  rightHandSide[0] = 1.0;
  rightHandSide[1] = 4.0;
  rightHandSide[2] = 1.0;

  linearAlgebraLib::ConjugateGradient solver(3);  
  solver.setRightHandSide(rightHandSide);
  solver.setCoefficientMatrix(matrix);

  // Act
  linearAlgebraLib::Vector solution = solver.solve(100, 1e-12);

  // Assert
  ASSERT_NEAR(solution[0], 1.0, 1e-8);
  ASSERT_NEAR(solution[1], 0.0, 1e-8);
  ASSERT_NEAR(solution[2], 1.0, 1e-8);
}