#include "gtest/gtest.h"

#include "linearAlgebraLib/linearAlgebraLib.hpp"

TEST(MatrixVectorMultiplicationTest, MatrixVectorMultiplication) {
  // Arrange
  linearAlgebraLib::SparseMatrixCSR matrix(3, 3);
  matrix.set(0, 0, 1.0);
  matrix.set(0, 1, 2.0);
  matrix.set(0, 2, 0.0);
  matrix.set(1, 0, 2.0);
  matrix.set(1, 1, 1.0);
  matrix.set(1, 2, 2.0);
  matrix.set(2, 0, 0.0);
  matrix.set(2, 1, 2.0);
  matrix.set(2, 2, 1.0);

  linearAlgebraLib::Vector vector(3);
  vector[0] = 1.0;
  vector[1] = 0.0;
  vector[2] = 1.0;

  // Act
  auto result = matrix * vector;

  // Assert
  ASSERT_NEAR(result[0], 1.0, 1e-8);
  ASSERT_NEAR(result[1], 4.0, 1e-8);
  ASSERT_NEAR(result[2], 1.0, 1e-8);
}