#pragma once

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__)
  #if defined(COMPILEDLL)
    #define LINEARALGEBRALIB_EXPORT __declspec(dllexport)
  #elif defined(COMPILELIB)
    #define LINEARALGEBRALIB_EXPORT
  #else
    #define LINEARALGEBRALIB_EXPORT __declspec(dllimport)
  #endif
#else
  #define LINEARALGEBRALIB_EXPORT
#endif

#include <iostream>
#include <vector>
#include <cassert>
#include <cmath>

namespace linearAlgebraLib {

class Vector {
public:
  using VectorType = std::vector<double>;

public:
  LINEARALGEBRALIB_EXPORT Vector(const unsigned &size);

  LINEARALGEBRALIB_EXPORT unsigned size() const;

  LINEARALGEBRALIB_EXPORT Vector transpose();
  LINEARALGEBRALIB_EXPORT double getL2Norm() const;

  LINEARALGEBRALIB_EXPORT const double &operator[](unsigned index) const;
  LINEARALGEBRALIB_EXPORT double &operator[](unsigned index);

  LINEARALGEBRALIB_EXPORT Vector operator+(const Vector &other);
  LINEARALGEBRALIB_EXPORT Vector operator-(const Vector &other);

  LINEARALGEBRALIB_EXPORT Vector &operator*(const double &scaleFactor);
  LINEARALGEBRALIB_EXPORT friend Vector operator*(const double &scaleFactor, Vector vector);  
  LINEARALGEBRALIB_EXPORT double operator*(const Vector &other);
  
  LINEARALGEBRALIB_EXPORT friend std::ostream &operator<<(std::ostream &out, const Vector &vector);

private:
  VectorType _vector;
  bool _isRowVector = false;
};

} // namespace linearAlgebraLib