#pragma once

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__)
  #if defined(COMPILEDLL)
    #define LINEARALGEBRALIB_EXPORT __declspec(dllexport)
  #elif defined(COMPILELIB)
    #define LINEARALGEBRALIB_EXPORT
  #else
    #define LINEARALGEBRALIB_EXPORT __declspec(dllimport)
  #endif
#else
  #define LINEARALGEBRALIB_EXPORT
#endif

#include <iostream>
#include <algorithm>
#include <vector>
#include <cassert>

#include "linearAlgebraLib/src/vector.hpp"

namespace linearAlgebraLib {

class SparseMatrixCSR {
public:
  LINEARALGEBRALIB_EXPORT SparseMatrixCSR(unsigned rows, unsigned _columns);

  LINEARALGEBRALIB_EXPORT void set(unsigned row, unsigned column, double value);
  LINEARALGEBRALIB_EXPORT double get(unsigned row, unsigned column) const;

  LINEARALGEBRALIB_EXPORT unsigned getNumberOfRows() const;
  LINEARALGEBRALIB_EXPORT unsigned getNumberOfColumns() const;

  LINEARALGEBRALIB_EXPORT Vector operator*(const Vector& rhs);
  LINEARALGEBRALIB_EXPORT friend SparseMatrixCSR operator*(const double &scaleFactor, const SparseMatrixCSR &matrix);
  LINEARALGEBRALIB_EXPORT friend std::ostream &operator<<(std::ostream &os, const SparseMatrixCSR &rhs);

private:
  std::vector<double> _values;
  std::vector<unsigned> _columns;
  std::vector<unsigned> _rows;
  unsigned _numberOfRows;
  unsigned _numberOfColumns;
};

} // namespace linearAlgebraLib