#pragma once

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__)
  #if defined(COMPILEDLL)
    #define LINEARALGEBRALIB_EXPORT __declspec(dllexport)
  #elif defined(COMPILELIB)
    #define LINEARALGEBRALIB_EXPORT
  #else
    #define LINEARALGEBRALIB_EXPORT __declspec(dllimport)
  #endif
#else
  #define LINEARALGEBRALIB_EXPORT
#endif

#include "linearAlgebraLib/src/sparseMatrixCSR.hpp"
#include "linearAlgebraLib/src/vector.hpp"

namespace linearAlgebraLib {

class LINEARALGEBRALIB_EXPORT LinearAlgebraSolverBase {
public:
  LinearAlgebraSolverBase(unsigned numberOfCells);
  virtual ~LinearAlgebraSolverBase() = default;

  void setCoefficientMatrix(const SparseMatrixCSR &matrix);
  void setRightHandSide(const Vector &rhs);
  
  virtual Vector solve(unsigned maxIterations, double convergenceThreshold) = 0;

protected:
  SparseMatrixCSR _coefficientMatrix;
  Vector _rightHandSide;
};

} // namespace linearAlgebraLib