#include "linearAlgebraLib/src/linearAlgebraSolverBase.hpp"

namespace linearAlgebraLib {

LinearAlgebraSolverBase::LinearAlgebraSolverBase(unsigned numberOfCells) :
  _coefficientMatrix(numberOfCells, numberOfCells), _rightHandSide(numberOfCells) { }

void LinearAlgebraSolverBase::setCoefficientMatrix(const SparseMatrixCSR &matrix) {
  _coefficientMatrix = matrix;
}

void LinearAlgebraSolverBase::setRightHandSide(const Vector &rhs) {
  _rightHandSide = rhs;
}

} // namespace linearAlgebraLib
