#pragma once

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__)
  #if defined(COMPILEDLL)
    #define LINEARALGEBRALIB_EXPORT __declspec(dllexport)
  #elif defined(COMPILELIB)
    #define LINEARALGEBRALIB_EXPORT
  #else
    #define LINEARALGEBRALIB_EXPORT __declspec(dllimport)
  #endif
#else
  #define LINEARALGEBRALIB_EXPORT
#endif

#include <iostream>

#include "linearAlgebraLib/src/linearAlgebraSolverBase.hpp"
#include "linearAlgebraLib/src/sparseMatrixCSR.hpp"
#include "linearAlgebraLib/src/vector.hpp"

namespace linearAlgebraLib {

class LINEARALGEBRALIB_EXPORT ConjugateGradient : public LinearAlgebraSolverBase {
public:
  ConjugateGradient(unsigned numberOfCells);
  virtual Vector solve(unsigned maxIterations, double convergenceThreshold) final override;
};

} // namespace linearAlgebraLib