#!/bin/bash

rm -rf build
mkdir -p build

# compile source files into object code
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. linearAlgebraLib/src/sparseMatrixCSR.cpp -o build/sparseMatrixCSR.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. linearAlgebraLib/src/vector.cpp -o build/vector.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. linearAlgebraLib/src/linearAlgebraSolverBase.cpp -o build/linearAlgebraSolver.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. linearAlgebraLib/src/conjugateGradient.cpp -o build/conjugateGradient.o

# link object files into dynamic library
ar rcs build/libLinearAlgebra.a build/sparseMatrixCSR.o build/vector.o build/linearAlgebraSolver.o build/conjugateGradient.o

# compile test code
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. -I ~/libs/include ./tests/unit/testVector.cpp -o ./build/testVector.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. -I ~/libs/include ./tests/unit/testMatrix.cpp -o ./build/testMatrix.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. -I ~/libs/include ./tests/unit/testConjugateGradient.cpp -o ./build/testConjugateGradient.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. -I ~/libs/include ./tests/integration/testMatrixVectorMultiplication.cpp -o ./build/testMatrixVectorMultiplication.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. -I ~/libs/include ./tests/system/testHeatEquation.cpp -o ./build/testHeatEquation.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. -I ~/libs/include ./tests/mainTest.cpp -o ./build/mainTest.o

# compile main function and link library into executable
g++ -o build/linearAlgebraTest ./build/mainTest.o ./build/testHeatEquation.o ./build/testVector.o ./build/testMatrix.o ./build/testConjugateGradient.o ./build/testMatrixVectorMultiplication.o  -Lbuild -L ~/libs/lib -lLinearAlgebra -lgtest

# remove object files
rm build/*.o

# run
echo "Running dynamic library example"
./build/linearAlgebraTest