# clean up before building
Remove-Item .\build -Force -Recurse
New-Item -Name "build" -ItemType "directory"

# compile source files into object files
cl.exe /nologo /EHsc /std:c++20 /I. /c /DCOMPILEDLL .\linearAlgebraLib\src\sparseMatrixCSR.cpp /Fo".\build\sparseMatrixCSR.obj"
cl.exe /nologo /EHsc /std:c++20 /I. /c /DCOMPILEDLL .\linearAlgebraLib\src\vector.cpp /Fo".\build\vector.obj"
cl.exe /nologo /EHsc /std:c++20 /I. /c /DCOMPILEDLL .\linearAlgebraLib\src\linearAlgebraSolverBase.cpp /Fo".\build\linearAlgebraSolverBase.obj"
cl.exe /nologo /EHsc /std:c++20 /I. /c /DCOMPILEDLL .\linearAlgebraLib\src\conjugateGradient.cpp /Fo".\build\conjugateGradient.obj"

# link object files into dynamic library
link.exe /nologo /DLL /OUT:build\linearAlgebra.dll .\build\sparseMatrixCSR.obj .\build\vector.obj .\build\linearAlgebraSolverBase.obj .\build\conjugateGradient.obj

# compile test code
cl.exe /nologo /EHsc /std:c++20 /I. /I "C:\libraries\include" /c /DCOMPILEDLL .\tests\unit\testVector.cpp /Fo".\build\testVector.obj"
cl.exe /nologo /EHsc /std:c++20 /I. /I "C:\libraries\include" /c /DCOMPILEDLL .\tests\unit\testMatrix.cpp /Fo".\build\testMatrix.obj"
cl.exe /nologo /EHsc /std:c++20 /I. /I "C:\libraries\include" /c /DCOMPILEDLL .\tests\unit\testConjugateGradient.cpp /Fo".\build\testConjugateGradient.obj"
cl.exe /nologo /EHsc /std:c++20 /I. /I "C:\libraries\include" /c /DCOMPILEDLL .\tests\integration\testMatrixVectorMultiplication.cpp /Fo".\build\testMatrixVectorMultiplication.obj"
cl.exe /nologo /EHsc /std:c++20 /I. /I "C:\libraries\include" /c /DCOMPILEDLL .\tests\system\testHeatEquation.cpp /Fo".\build\testHeatEquation.obj"
cl.exe /nologo /EHsc /std:c++20 /I. /I "C:\libraries\include" /c /DCOMPILEDLL .\tests\mainTest.cpp /Fo".\build\mainTest.obj"

# link object files
cl.exe /nologo /EHsc /std:c++20 .\build\mainTest.obj .\build\testVector.obj .\build\testMatrix.obj .\build\testConjugateGradient.obj .\build\testMatrixVectorMultiplication.obj .\build\testHeatEquation.obj /Fe".\build\linearAlgebraTest.exe" /link /MACHINE:x64 /LIBPATH:"C:\libraries\lib" /LIBPATH:.\build linearAlgebra.lib gtest.lib

# execute the test
.\build\linearAlgebraTest.exe