#!/bin/bash

rm -rf build
mkdir -p build

# compile
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. ./linearAlgebraLib/src/sparseMatrixCSR.cpp -o ./build/sparseMatrixCSR.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. ./linearAlgebraLib/src/vector.cpp -o ./build/vector.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. ./linearAlgebraLib/src/linearAlgebraSolverBase.cpp -o ./build/linearAlgebraSolverBase.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. ./linearAlgebraLib/src/conjugateGradient.cpp -o ./build/conjugateGradient.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. -I ~/libs/include ./tests/unit/testVector.cpp -o ./build/testVector.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. -I ~/libs/include ./tests/unit/testMatrix.cpp -o ./build/testMatrix.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. -I ~/libs/include ./tests/unit/testConjugateGradient.cpp -o ./build/testConjugateGradient.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. -I ~/libs/include ./tests/integration/testMatrixVectorMultiplication.cpp -o ./build/testMatrixVectorMultiplication.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. -I ~/libs/include ./tests/system/testHeatEquation.cpp -o ./build/testHeatEquation.o
g++ -c -g -O0 -std=c++20 -Wall -Wextra -I. -I ~/libs/include ./tests/mainTest.cpp -o ./build/mainTest.o

# link
g++ -o build/linearAlgebraTest ./build/mainTest.o ./build/testHeatEquation.o ./build/conjugateGradient.o ./build/linearAlgebraSolverBase.o ./build/vector.o ./build/sparseMatrixCSR.o ./build/testVector.o ./build/testMatrix.o ./build/testConjugateGradient.o ./build/testMatrixVectorMultiplication.o  -L ~/libs/lib -lgtest

# run
./build/linearAlgebraTest