#!/bin/bash

rm -rf build
mkdir -p build

# compile source files into object code
g++ -c -std=c++20 -fPIC -I. -I ~/libs/include ./meshReaderLib/src/readMeshBase.cpp -o ./build/readMeshBase.o
g++ -c -std=c++20 -fPIC -I. -I ~/libs/include ./meshReaderLib/src/readStructuredMesh.cpp -o ./build/readStructuredMesh.o
g++ -c -std=c++20 -fPIC -I. -I ~/libs/include ./meshReaderLib/src/readUnstructuredmesh.cpp -o ./build/readUnstructuredmesh.o

# link object files into static library
g++ -shared -O3 -Wall -Wextra -I. -o build/libMeshReader.so build/readMeshBase.o build/readStructuredMesh.o build/readUnstructuredmesh.o

# compile tests
g++ -c -std=c++20 -I. -I ~/libs/include ./tests/unit/testStructuredGrid.cpp -o ./build/testStructuredGrid.o
g++ -c -std=c++20 -I. -I ~/libs/include ./tests/unit/testUnstructuredGrid.cpp -o ./build/testUnstructuredGrid.o
g++ -c -std=c++20 -I. -I ~/libs/include ./tests/mainTest.cpp -o ./build/mainTest.o

# compile main function and link library into executable
g++ -Wall -Wextra -I. ./build/mainTest.o ./build/testStructuredGrid.o ./build/testUnstructuredGrid.o -o build/cgnsTest -Lbuild -L ~/libs/lib -Wl,-rpath=build -lMeshReader -lcgns -lgtest

# remove object files
rm build/*.o

# run
./build/cgnsTest