# clean up before building
Remove-Item .\build -Force -Recurse
New-Item -Name "build" -ItemType "directory"
Copy-Item "C:\libraries\bin\hdf5.dll" -Destination .\build
Copy-Item "C:\libraries\bin\zlib.dll" -Destination .\build

# compile source files into object files for CGNS library
cl.exe /nologo /EHsc /std:c++20 /I. /I "C:\libraries\include" /c /O2 /DCOMPILEDLL .\meshReaderLib\src\readMeshBase.cpp /Fo".\build\readMeshBase.obj"
cl.exe /nologo /EHsc /std:c++20 /I. /I "C:\libraries\include" /c /O2 /DCOMPILEDLL .\meshReaderLib\src\readStructuredMesh.cpp /Fo".\build\readStructuredMesh.obj"
cl.exe /nologo /EHsc /std:c++20 /I. /I "C:\libraries\include" /c /O2 /DCOMPILEDLL .\meshReaderLib\src\readUnstructuredMesh.cpp /Fo".\build\readUnstructuredMesh.obj"

# link dynamic library
link.exe /nologo /DLL /OUT:build\meshReader.dll build\readMeshBase.obj build\readStructuredMesh.obj build\readUnstructuredMesh.obj /LIBPATH:"C:\libraries\lib" cgns.lib hdf5.lib msvcrt.lib libcmt.lib

# compile tests
cl.exe /nologo /EHsc /std:c++20 /I. /I "C:\libraries\include" /c /O2 /DCOMPILEDLL .\tests\mainTest.cpp /Fo".\build\mainTest.obj"
cl.exe /nologo /EHsc /std:c++20 /I. /I "C:\libraries\include" /c /O2 /DCOMPILEDLL .\tests\unit\testStructuredGrid.cpp /Fo".\build\testStructuredGrid.obj"
cl.exe /nologo /EHsc /std:c++20 /I. /I "C:\libraries\include" /c /O2 /DCOMPILEDLL .\tests\unit\testUnstructuredGrid.cpp /Fo".\build\testUnstructuredGrid.obj"

# link library into main executable
cl.exe /nologo /EHsc /std:c++20 .\build\mainTest.obj .\build\testStructuredGrid.obj .\build\testUnstructuredGrid.obj /Fe".\build\cgnsTest.exe" /link /MACHINE:x64 /LIBPATH:"C:\libraries\lib" /LIBPATH:.\build meshReader.lib gtest.lib cgns.lib hdf5.lib msvcrt.lib libcmt.lib

# clean up
Remove-Item build\*.obj

# test executable
.\build\cgnsTest.exe