#!/bin/bash

rm -rf build
mkdir -p build

# compile source files into object files
g++ -c -std=c++20 -I. -I ~/libs/include ./meshReaderLib/src/readMeshBase.cpp -o ./build/readMeshBase.o
g++ -c -std=c++20 -I. -I ~/libs/include ./meshReaderLib/src/readStructuredMesh.cpp -o ./build/readStructuredMesh.o
g++ -c -std=c++20 -I. -I ~/libs/include ./meshReaderLib/src/readUnstructuredMesh.cpp -o ./build/readUnstructuredMesh.o
g++ -c -std=c++20 -I. -I ~/libs/include ./tests/unit/testStructuredGrid.cpp -o ./build/testStructuredGrid.o
g++ -c -std=c++20 -I. -I ~/libs/include ./tests/unit/testUnstructuredGrid.cpp -o ./build/testUnstructuredGrid.o
g++ -c -std=c++20 -I. -I ~/libs/include ./tests/mainTest.cpp -o ./build/mainTest.o

# link object files against CGNS library and its dependencies
g++ -std=c++20 ./build/mainTest.o ./build/testStructuredGrid.o ./build/testUnstructuredGrid.o ./build/readMeshBase.o ./build/readStructuredMesh.o ./build/readUnstructuredMesh.o -o ./build/cgnsTest -L ~/libs/lib -lcgns -lgtest

# run executable
./build/cgnsTest