#include <cassert>
#include <iostream>

#include "tests/assertFloatingPointNumber.hpp"
#include "src/complexNumber.hpp"

void testComplexMagnitude() {
  // Arrange
  ComplexNumber a(3.0, 4.0);
  
  // Act
  auto magnitude = a.magnitude();
  
  // Assert
  assert(floatingPointEqual(magnitude, 5.0, 1e-10));
}

void testComplexConjugate() {
  // Arrange
  ComplexNumber a(3.0, 4.0);
  
  // Act
  a.conjugate();
  
  // Assert
  assert(floatingPointEqual(a.Re(), 3.0, 1e-10));
  assert(floatingPointEqual(a.Im(), -4.0, 1e-10));
}

void testComplexAddition() {
  // Arrange
  ComplexNumber a(1.2, -0.3);
  ComplexNumber b(1.8, 5.3);
  
  // Act
  ComplexNumber c = a + b;
  
  // Assert
  assert(floatingPointEqual(c.Re(), 3.0, 1e-10));
  assert(floatingPointEqual(c.Im(), 5.0, 1e-10));
}

void testComplexSubtraction() {
  // Arrange
  ComplexNumber a(1.2, -0.3);
  ComplexNumber b(1.8, 5.3);
  
  // Act
  ComplexNumber c = a - b;
  
  // Assert
  assert(floatingPointEqual(c.Re(), -0.6, 1e-10));
  assert(floatingPointEqual(c.Im(), -5.6, 1e-10));
}

void testComplexMultiplication() {
  // Arrange
  ComplexNumber a(1.2, -0.3);
  ComplexNumber b(1.8, 5.3);
  
  // Act
  ComplexNumber c = a * b;
  
  // Assert
  assert(floatingPointEqual(c.Re(), 3.75, 1e-10));
  assert(floatingPointEqual(c.Im(), 5.82, 1e-10));
}

void testComplexDivision() {
  // Arrange
  ComplexNumber a(1.0, -2.0);
  ComplexNumber b(1.0, 2.0);
  
  // Act
  ComplexNumber c = a / b;
  
  // Assert
  assert(floatingPointEqual(c.Re(), -0.6, 1e-10));
  assert(floatingPointEqual(c.Im(), -0.8, 1e-10));
}

#include <complex>

int main() {
  testComplexMagnitude();
  testComplexConjugate();
  testComplexAddition();
  testComplexSubtraction();
  testComplexMultiplication();
  testComplexDivision();

  std::cout << "All tests passed!" << std::endl;

  return 0;
}