#include <limits>
#include <cmath>

template<typename T, typename std::enable_if_t<std::is_floating_point<T>::value>* = nullptr>
bool floatingPointEqual(T A, T B) {
  const T difference = std::fabs(A - B);
  A = std::fabs(A);
  B = std::fabs(B);
  const T largestValue = A > B ? A : B;
  const T maxRelativeDifference = std::numeric_limits<T>::epsilon();

  if (difference < largestValue * maxRelativeDifference)
    return true;
  return false;
}