#pragma once

#include <iostream>
#include <cmath>

class ComplexNumber {
public:
	ComplexNumber(const double &real, const double &imaginary) :
    _real(real), _imaginary(imaginary) { }
	
	double Re() const { return _real; }
	double Im() const { return _imaginary; }

  void conjugate() {
    _imaginary *= -1.0;
  }

  double magnitude() const {
    return std::sqrt(_real * _real + _imaginary * _imaginary);
  }
	
	ComplexNumber operator+(const ComplexNumber &other) {
		ComplexNumber c(0, 0);
		c._real = _real + other._real;
		c._imaginary = _imaginary + other._imaginary;
		return c;
	}

  ComplexNumber operator-(const ComplexNumber &other) {
    ComplexNumber c(0, 0);
    c._real = _real - other._real;
    c._imaginary = _imaginary - other._imaginary;
    return c;
  }

  ComplexNumber operator*(const ComplexNumber &other) {
    ComplexNumber c(0, 0);
    c._real = _real * other._real - _imaginary * other._imaginary;
    c._imaginary = _real * other._imaginary + _imaginary * other._real;
    return c;
  }

  ComplexNumber operator/(const ComplexNumber &other) {
    ComplexNumber c(0, 0);
    c._real = (_real * other._real + _imaginary * other._imaginary) /
      (other._real * other._real + other._imaginary * other._imaginary);
    c._imaginary = (_imaginary * other._real - _real * other._imaginary) /
      (other._real * other._real + other._imaginary * other._imaginary);
    return c;
  }

  friend std::ostream &operator<<(std::ostream &os, const ComplexNumber &c) {
    os << "(" << c._real << ", " << c._imaginary << ")";
    return os;
  }
	
private:
	double _real;
	double _imaginary;
};