#pragma once

#include <iostream>
#include <algorithm>
#include <vector>
#include <cassert>

#include "linearAlgebraLib/src/vector.hpp"

namespace linearAlgebraLib {

class SparseMatrixCSR {
public:
  SparseMatrixCSR(unsigned rows, unsigned _columns);

  void set(unsigned row, unsigned column, double value);
  double get(unsigned row, unsigned column) const;

  unsigned getNumberOfRows() const;
  unsigned getNumberOfColumns() const;

  Vector operator*(const Vector& rhs);
  friend SparseMatrixCSR operator*(const double &scaleFactor, const SparseMatrixCSR &matrix);
  friend std::ostream& operator<<(std::ostream &os, const SparseMatrixCSR &rhs);

private:
  std::vector<double> _values;
  std::vector<unsigned> _columns;
  std::vector<unsigned> _rows;
  unsigned _numberOfRows;
  unsigned _numberOfColumns;
};

} // namespace linearAlgebraLib