#pragma once

#include "linearAlgebraLib/src/sparseMatrixCSR.hpp"
#include "linearAlgebraLib/src/vector.hpp"

namespace linearAlgebraLib {

class LinearAlgebraSolverBase {
public:
  LinearAlgebraSolverBase(unsigned numberOfCells);
  virtual ~LinearAlgebraSolverBase() = default;

  void setCoefficientMatrix(const SparseMatrixCSR &matrix);
  void setRightHandSide(const Vector &rhs);
  
  virtual Vector solve(unsigned maxIterations, double convergenceThreshold) = 0;

protected:
  SparseMatrixCSR _coefficientMatrix;
  Vector _rightHandSide;
};

} // namespace linearAlgebraLib