#pragma once

#include <iostream>
#include <vector>
#include <cassert>
#include <cmath>

namespace linearAlgebraLib {

class Vector {
public:
  using VectorType = std::vector<double>;

public:
  Vector(const unsigned &size);

  unsigned size() const;

  Vector transpose();
  double getL2Norm() const;

  const double &operator[](unsigned index) const;
  double &operator[](unsigned index);

  Vector operator+(const Vector &other);
  Vector operator-(const Vector &other);

  Vector &operator*(const double &scaleFactor);
  friend Vector operator*(const double &scaleFactor, Vector vector);  
  double operator*(const Vector &other);
  
  friend std::ostream &operator<<(std::ostream &out, const Vector &vector);

private:
  VectorType _vector;
  bool _isRowVector = false;
};

} // namespace linearAlgebraLib