# Introduction

This is a simple demonstration of how to implement a linear system of equation solver using a sparse matrix in compressed row storage (CRS) representation. The linear system is solved using the conjugate gradient method.

An example code is given for the 1D heat equation and the full write-up that explains the discretisation of the equation, as well as the implementation of the library is provided at [cfd.university](https://cfd.university/learn/how-to-compiler-write-and-use-cfd-libraries-in-c/)

# Usage

A build script for pretty much each build system under the sun is provided (CMake, Make, MSBuild, Ninja, Meson, Autotools). Pick your favorite and compile away. There are also custom build scripts (implemented as batch/shell files) that you can use to compile the library and run it on your favorite operating system.

## CMake
```bash
mkdir build
cd build
cmake -DCMAKE_BUILD_TYPE=Debug -G Ninja .. 
cmake --build . --config Debug -j 4
```

## Make
```bash
make init
make -j 4
make run
```

## MSBuild
```bash
msbuild build.vcxproj
msbuild build.vcxproj /t:run
```

## Ninja
```bash
ninja init
ninja -j 4
ninja run
```

## Meson
```bash
meson setup build
meson compile -C build -j 4
```

## Autotools
```bash
autoheader && aclocal && autoconf && automake --add-missing
./configure --prefix=/path/to/executable/
make
make install
```

## Custom build scripts

If you can't be bothered, you can also run the simplified ```buildAndRun.bat``` script on Windows or the ```buildAndRun.sh``` script on UNIX (Linux, macOS) to compile and run the code.

If you still can't be bothered but want to understand how to compile a static, dynamic, or header-only version of the library using raw compiler inputs, you can use the following scripts:

Windows:
* ```testStaticLib.bat```
* ```testDynamicLib.bat```
* ```testHeaderOnlyLib.bat```

UNIX (Linux, macOS):
* ```testStaticLib.sh```
* ```testDynamicLib.sh```
* ```testHeaderOnlyLib.sh```

# Output

The above-mentioned script will compile all library code and execute a test function, which is implemented in the ```main.cpp``` file. At the end of the file, the solution of the heat equation is checked, if the difference against the exact solution is less than 1e-8, the solver is deemed to have solved the equation correctly.

A message will be printed to the console stating that the simulation was successful, and the final residual will be printed. If it was not successful, an error message will be printed.