#!/bin/bash

rm -rf build
mkdir -p build

# compile source files into object code
g++ -c -std=c++20 -fpic -O3 -I. -I~/libs/include meshReaderLib/src/readMeshBase.cpp -o build/readMeshBase.o
g++ -c -std=c++20 -fpic -O3 -I. -I~/libs/include meshReaderLib/src/readStructuredMesh.cpp -o build/readStructuredMesh.o
g++ -c -std=c++20 -fpic -O3 -I. -I~/libs/include meshReaderLib/src/readUnstructuredmesh.cpp -o build/readUnstructuredmesh.o
g++ -c -std=c++20 -O3 -I. -I~/libs/include main.cpp -o build/main.o

# link object files into static library
g++ -shared -O3 -Wall -Wextra -I. -o build/libMeshReader.so build/readMeshBase.o build/readStructuredMesh.o build/readUnstructuredmesh.o

# compile main function and link library into executable
g++ -O3 -Wall -Wextra -I. build/main.o -o build/cgnsTest -Lbuild -L~/libs/lib -Wl,-rpath=build -lMeshReader -lcgns

# remove object files
rm build/*.o

# run
./build/cgnsTest