#!/bin/bash

rm -rf build
mkdir -p build

# compile source files into object files
g++ -std=c++20 -I. -I ~/libs/include -c ./meshReaderLib/src/readMeshBase.cpp -o ./build/readMeshBase.o
g++ -std=c++20 -I. -I ~/libs/include -c ./meshReaderLib/src/readStructuredMesh.cpp -o ./build/readStructuredMesh.o
g++ -std=c++20 -I. -I ~/libs/include -c ./main.cpp -o ./build/main.o

# link object files against CGNS library and its dependencies
g++ -std=c++20 ./build/main.o ./build/readMeshBase.o ./build/readStructuredMesh.o -o ./build/cgnsTest -L~/libs/lib -lcgns

# run executable
./build/cgnsTest